.\" $Id: sccsput.man,v 6.0 1991/10/24 08:43:08 ste_cm Rel $
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp .5
..
.TH SCCSPUT 1
.SH NAME
.PP
\fBsccsput\fR \- SCCS check-in script
.SH USAGE
.PP
\fBsccsput\fI [options] [file-specifications]
.SH SYNOPSIS
.PP
\fBSccsput\fR is a simple, easy to use interface to \fIsccs\fR
(\fBs\fRource \fBc\fRode \fBc\fRontrol \fBs\fRystem).
For each file specified as input, it checks differences against the
previously archived version and prompts you for change history comments.
.SH DESCRIPTION
.PP
\fBSccsput\fR uses the \fIsccs\fR utilities \fBadmin\fR and \fBdelta\fR to maintain versions of a given source file in a dependent directory
named "SCCS".
It is more than an integration of the \fBadmin\fR
and \fBdelta\fR utilities, however:
.TP
.B \-
It checks to ensure that each file is indeed a text
file (so that you do not accidentally archive ".o" files, for
example).
.TP
.B \-
If you give \fBsccsput\fR a directory name, it will
recur, checking-in files in the directory.
.TP
.B \-
For each file which has a corresponding "s." file, \fBsccsput\fR compares the two (using \fBdiff\fR) and pipes the result
through the pager.
.TP
.B \-
An option is provided so that you may direct \fBsccsput\fR
to perform the differencing without checking the file into sccs.
.TP
.B \-
The "s." file is post-processed by \fBsccsput\fR
so that the check-in date matches the file's modification date.
.PP
The last point is the fundamental advantage offered by \fBsccsput\fR.
The ordinary \fIsccs\fR methodology uses the current date as the
check-in date.
This works well only for large projects in which a
central project administrator is responsible for controlling the versions
of source files.
It does not work well for small projects, for which \fIsccs\fR's primary advantage is its compact storage of multiple versions
of a file.
.PP
By using the file's modification date as a reference, you can more
easily back
up to a meaningful version \- by date, rather than version
number.
(By working exclusively in terms of modification date,
you lose the ability to specify sccs release numbers --
given the complexity
of \fIsccs\fR's interface for release and version numbers, this
is probably not such a great loss).
.PP
\fBSccsput\fR integrates all of the functions used in the \fIsccs\fR
check-in process into one utility program.
.SH OPTIONS
.PP
Some of the options which you may specify to \fBsccsput\fR are
passed through to the underlying utilities.
Others represent extensions:
.TP
-\fBb\fR
is passed to \fBdiff\fR, and directs it to ignore
trailing blanks on a line, and to treat repeated blanks as a single
blank.
.TP
-\fBc\fR
directs \fBsccsput\fR to use \fBcat\fR rather
than the \fBPAGER\fR (usually \fBmore\fR) to display differences.
This is most useful in an Apollo pad, since the \fBmore\fR program
would otherwise switch to VT100 emulator mode.
.TP
\fR-\fBf\fR
forces a check-in, ignoring the output
of the \fBfile\fR utility, which identifies text files.
.TP
-\fBl\fR \fIfile\fR
causes \fBsccsput\fR to generate
a log-file of the files which are processed, and all differences which
are encountered.
The log-file is inherited in recursion to lower
directory levels (i.e., it is written to the same place).
.TP
-\fBn\fR
instructs \fBsccsput\fR to test for differences,
but not to check the files into \fIsccs\fR.
.TP
-\fBs\fR
suppresses some of the messages generated by the \fIsccs\fR \fBdelta\fR utility describing the number of lines changed,
etc.
.SH OPERATIONS
.PP
The \fBsccsput\fR utility is designed for use in small development
projects.
The methodology for this tool follows:
.TP
.B \-
Develop source files "normally".
Each file should
contain sccs keywords (see \fIget\ (1)\fR) so that you will be
able to distinguish checked-out files.
The \fIsccs\fR keywords
should appear at the top of your source file, for consistency.
In
C language programs, the convention is to make a string which will
permit the \fBwhat\fR utility to show the versions of the modules
which make up a program:
.DS
#ifndef	lint
static	char	sccs_id[] = "@(#)sccsput.doc	1.1 88/05/05
08:07:16";
#endif
.DE
.TP
.B \-
Periodically archive (with \fBsccsput\fR) those
versions of files which you wish to keep
(You should never have programs which have new features
which you wish to keep, while there are defects in other parts of
the program -- that would be an unsound approach to development!).
.TP
.B \-
When you reach the point of releasing the program, ensure
that all source files have been checked-in.
The directory editor
(\fBded\fR) is useful for reviewing the check-in dates.
.TP
.B \-
Copy the directory containing your program to the release
directory.
Purge all files, except those which are stored in the \fIsccs\fR subdirectories.
Use \fBsccsget\fR to extract the files
(the unadorned \fBget\fR utility will work, of course,
but it retains the file modification dates).
.TP
.B \-
Ensure that all files have been checked-in and released.
You may use \fBdiff\fR to compare the directories \- the only
differences should be the substituted \fIsccs\fR keywords.
.TP
.B \-
Build the released version of your program.
All files
should be present.
No embedded path names should refer to your development
copy.
To ensure good isolation, you may change the permissions on
your development directory temporarily.
.PP
\fBSccsput\fR checks your source file out after the check-in, automatically.
This is done to facilitate development.
A check-in simply adds the
latest changes to a file onto the archive.
.PP
When checking files into \fIsccs\fR, it is a good idea to make
a test run (using the "-\fBn\fR" option) so that you can inspect
the differences.
For example, you may have forgotten to remove (or
bypass) debugging stubs.
Or, you may have been editing a checked-out
file (with the \fIsccs\fR keywords substituted).
\fBSccsput\fR
would archive this anyway.
If you forget, and wish to kill the check-in,
wait until the "comments?" prompt is issued by the \fBdelta\fR
utility.
At this point you may kill \fBsccsput\fR without having
to clean up temporary files.
.PP
If you do not have write-permission on the "SCCS" directory, but
wish to review changes, use the "-\fBn\fR" option.
The intermediate
files are written in the \fB/tmp\fR directory.
.SH ENVIRONMENT
.PP
\fBSccsput\fR is a Bourne shell script.
On Apollo DOMAIN/IX, it
uses System\ 5 features including \fIdirname\ (1)\fR and \fIgetopt\ (1)\fR.
.PP
Environment variables imported by \fBsccsput\fR include:
.PP
\fBSccsput\fR also uses the following environment variables:
.TP
\fBNOTE\fR
Provides a default value for the delta comments.
Normally you should provide case-by-case comments for each file.
This variable is provided so that other programs can invoke \fBsccsput\fR.
If the \fBNOTE\fR variable is defined (i.e., non-null) it is used;
you will not be prompted for comments.
.TP
\fBPAGER\fR
identifies the program to use in displaying differences
between the file which is being checked in, and the previously archived
version.
There may be a lot of differences \- more than can be
shown on one screen.
.TP
\fBSCCS_DIR\fR
specifies the directory into which the \fIsccs\fR "s." files are stored.
If no specified, \fBsccsput\fR
assumes "SCCS".
.SH FILES
.PP
\fBSccsput\fR uses the following files
.TP
\fBsccsput\fR
the Bourne shell script
.TP
\fBputdelta\fR
A utility which invokes \fBadmin\fR
or \fBdelta\fR as required, and modifies the sccs "s."
file after check-in so that the check-in date matches the file's modification
date.
.SH ANTICIPATED CHANGES
.PP
Make \fBsccsput\fR clean up temporary files if it is interrupted.
.PP
Provide a mechanism for inserting dummy version numbers so that \fBsccsput\fR can bump the release number (for genuine major releases).
Currently,
the SID's are restricted to 1.1, 1.2, 1.3, etc.
.SH SEE ALSO
.PP
putdelta, sccsget, ded, admin\ (1), delta\ (1), diff\ (1), get\ (1),
rmdel\ (1), what\ (1)
.SH AUTHOR
.PP
Thomas Dickey (Software Productivity Consortium).
