.\" $Id: putdelta.man,v 6.0 1991/10/24 08:21:11 ste_cm Rel $
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp .5
..
.TH PUTDELTA 1
.SH NAME
.PP
\fBputdelta\fR \- SCCS check-in utility
.SH USAGE
.PP
\fBputdelta\fI [options] [file-specifications]
.SH SYNOPSIS
.PP
\fBPutdelta\fR is a simple, easy to use interface to \fIsccs\fR
(\fBs\fRource \fBc\fRode \fBc\fRontrol \fBs\fRystem).
It checks into the \fIsccs\fR archive all files specified.
.SH DESCRIPTION
.PP
\fBPutdelta\fR uses the \fIsccs\fR utilities \fBadmin\fR
and \fBdelta\fR to maintain versions of a given source file in
a dependent directory named "SCCS"
It is more than an integration
of the \fBadmin\fR and \fBdelta\fR utilities, however:
.TP
.B \-
If the \fIsccs\fR archive directory does not already
exist, \fBputdelta\fR creates it.
.TP
.B \-
If the file has not been locked, \fBputdelta\fR creates
a lock (i.e., a "p." file).
If a "p." file already exists, \fBputdelta\fR
will attempt to use the lock
However, if the lock belongs to another
user, \fBputdelta\fR will not check-in the file.
.TP
.B \-
\fBPutdelta\fR retains the executable-mode of the
file which is checked-in
That is, if it is a shell-script (and has
a mode such as 755), the mode of \fIsccs\fR "s." file is set
to 555
The \fBgetdelta\fR utility works in the opposite fashion,
setting the extracted file's mode to correspond to that of the "s."
file.
.TP
.B \-
\fBPutdelta\fR sets the "-n" option of delta,
so that your file is not deleted after check-in.
.TP
.B \-
The "s." file is post-processed by \fBputdelta\fR
so that the check-in date matches the file's modification date.
.PP
The last point is the fundamental advantage offered by \fBputdelta\fR.
The ordinary \fIsccs\fR methodology uses the current date as the
check-in date
This works well only for large projects in which a
central project administrator is responsible for controlling the versions
of source files
It does not work well for small projects, for which \fIsccs\fR's primary advantage is its compact storage of multiple versions
of a file.
.PP
By using the file's modification date as a reference, you can more
easily back up to a meaningful version \- by date, rather than
version number.
.PP
\fBPutdelta\fR integrates the essential functions used in the \fIsccs\fR check-in process into one utility program.
.SH OPTIONS
.PP
The options which you may specify to \fBputdelta\fR are passed
through to the underlying \fBadmin\fR and \fBdelta\fR utilities:
.TP
.B \-s
suppresses some of the messages generated by the \fIsccs\fR \fBadmin \fRand \fBdelta\fR utilities describing the number
of lines changed, etc.
.TP
.BI \-y text
specifies the change-history text.
You will be prompted for this if you do not supply it, in versions
after the first, by the \fBdelta\fR utility.
.SH OPERATIONS
.PP
\fBPutdelta\fR is designed to operate with the standard \fBsccs\fR
utilities with a minimum of fuss and bother
It retains your working
file after check-in since that facilitates development
In effect,
it simply appends the current version of each file which you specify
onto the archive.
.SH ENVIRONMENT
.PP
Environment variables imported by \fBputdelta\fR include:
.TP
.B SCCS_DIR
specifies the directory into which the \fIsccs\fR
"s." files are stored
If no specified, \fBputdelta\fR assumes
"SCCS".
.TP
.B TZ
is the prevailing timezone, which \fBputdelta\fR
uses to set the check-in date in the "s." file
\fBPutdelta\fR
sets the timezone to \fBEST5EDT\fR, in part to avoid conflict with \fBget\fR's date checking.
.SH FILES
.PP
\fBPutdelta\fR is a single binary file, written in C
It runs
in a UNIX\*R environment.
.SH ANTICIPATED CHANGES
.PP
Provide a mechanism for inserting dummy version numbers so that \fBputdelta\fR can bump the release number (for genuine major releases)
Currently,
the SID's are restricted to 1.1, 1.2, 1.3, etc.
.SH SEE ALSO
.PP
sccsput, sccsget, getdelta, admin\ (1), delta\ (1)
.SH AUTHOR
.PP
Thomas Dickey (Software Productivity Consortium).
