dnl $Id: aclocal.m4,v 12.16 2009/10/15 23:51:21 tom Exp $
dnl Macros for DED configure script.
dnl ---------------------------------------------------------------------------
dnl ---------------------------------------------------------------------------
dnl CF_ADD_SUBDIR_PATH version: 2 updated: 2007/07/29 10:12:59
dnl ------------------
dnl Append to a search-list for a nonstandard header/lib-file
dnl	$1 = the variable to return as result
dnl	$2 = the package name
dnl	$3 = the subdirectory, e.g., bin, include or lib
dnl $4 = the directory under which we will test for subdirectories
dnl $5 = a directory that we do not want $4 to match
AC_DEFUN([CF_ADD_SUBDIR_PATH],
[
test "$4" != "$5" && \
test -d "$4" && \
ifelse([$5],NONE,,[(test $5 = NONE || test -d $5) &&]) {
	test -n "$verbose" && echo "	... testing for $3-directories under $4"
	test -d $4/$3 &&          $1="[$]$1 $4/$3"
	test -d $4/$3/$2 &&       $1="[$]$1 $4/$3/$2"
	test -d $4/$3/$2/$3 &&    $1="[$]$1 $4/$3/$2/$3"
	test -d $4/$2/$3 &&       $1="[$]$1 $4/$2/$3"
	test -d $4/$2/$3/$2 &&    $1="[$]$1 $4/$2/$3/$2"
}
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_ARG_DISABLE version: 3 updated: 1999/03/30 17:24:31
dnl --------------
dnl Allow user to disable a normally-on option.
AC_DEFUN([CF_ARG_DISABLE],
[CF_ARG_OPTION($1,[$2],[$3],[$4],yes)])dnl
dnl ---------------------------------------------------------------------------
dnl CF_ARG_OPTION version: 3 updated: 1997/10/18 14:42:41
dnl -------------
dnl Restricted form of AC_ARG_ENABLE that ensures user doesn't give bogus
dnl values.
dnl
dnl Parameters:
dnl $1 = option name
dnl $2 = help-string
dnl $3 = action to perform if option is not default
dnl $4 = action if perform if option is default
dnl $5 = default option value (either 'yes' or 'no')
AC_DEFUN([CF_ARG_OPTION],
[AC_ARG_ENABLE($1,[$2],[test "$enableval" != ifelse($5,no,yes,no) && enableval=ifelse($5,no,no,yes)
  if test "$enableval" != "$5" ; then
ifelse($3,,[    :]dnl
,[    $3]) ifelse($4,,,[
  else
    $4])
  fi],[enableval=$5 ifelse($4,,,[
  $4
])dnl
  ])])dnl
dnl ---------------------------------------------------------------------------
dnl CF_CHECK_CACHE version: 11 updated: 2008/03/23 14:45:59
dnl --------------
dnl Check if we're accidentally using a cache from a different machine.
dnl Derive the system name, as a check for reusing the autoconf cache.
dnl
dnl If we've packaged config.guess and config.sub, run that (since it does a
dnl better job than uname).  Normally we'll use AC_CANONICAL_HOST, but allow
dnl an extra parameter that we may override, e.g., for AC_CANONICAL_SYSTEM
dnl which is useful in cross-compiles.
dnl
dnl Note: we would use $ac_config_sub, but that is one of the places where
dnl autoconf 2.5x broke compatibility with autoconf 2.13
AC_DEFUN([CF_CHECK_CACHE],
[
if test -f $srcdir/config.guess || test -f $ac_aux_dir/config.guess ; then
	ifelse([$1],,[AC_CANONICAL_HOST],[$1])
	system_name="$host_os"
else
	system_name="`(uname -s -r) 2>/dev/null`"
	if test -z "$system_name" ; then
		system_name="`(hostname) 2>/dev/null`"
	fi
fi
test -n "$system_name" && AC_DEFINE_UNQUOTED(SYSTEM_NAME,"$system_name")
AC_CACHE_VAL(cf_cv_system_name,[cf_cv_system_name="$system_name"])

test -z "$system_name" && system_name="$cf_cv_system_name"
test -n "$cf_cv_system_name" && AC_MSG_RESULT(Configuring for $cf_cv_system_name)

if test ".$system_name" != ".$cf_cv_system_name" ; then
	AC_MSG_RESULT(Cached system name ($system_name) does not agree with actual ($cf_cv_system_name))
	AC_MSG_ERROR("Please remove config.cache and try again.")
fi
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_DISABLE_ECHO version: 10 updated: 2003/04/17 22:27:11
dnl ---------------
dnl You can always use "make -n" to see the actual options, but it's hard to
dnl pick out/analyze warning messages when the compile-line is long.
dnl
dnl Sets:
dnl	ECHO_LT - symbol to control if libtool is verbose
dnl	ECHO_LD - symbol to prefix "cc -o" lines
dnl	RULE_CC - symbol to put before implicit "cc -c" lines (e.g., .c.o)
dnl	SHOW_CC - symbol to put before explicit "cc -c" lines
dnl	ECHO_CC - symbol to put before any "cc" line
dnl
AC_DEFUN([CF_DISABLE_ECHO],[
AC_MSG_CHECKING(if you want to see long compiling messages)
CF_ARG_DISABLE(echo,
	[  --disable-echo          display "compiling" commands],
	[
    ECHO_LT='--silent'
    ECHO_LD='@echo linking [$]@;'
    RULE_CC='	@echo compiling [$]<'
    SHOW_CC='	@echo compiling [$]@'
    ECHO_CC='@'
],[
    ECHO_LT=''
    ECHO_LD=''
    RULE_CC='# compiling'
    SHOW_CC='# compiling'
    ECHO_CC=''
])
AC_MSG_RESULT($enableval)
AC_SUBST(ECHO_LT)
AC_SUBST(ECHO_LD)
AC_SUBST(RULE_CC)
AC_SUBST(SHOW_CC)
AC_SUBST(ECHO_CC)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_FIND_LIBRARY version: 9 updated: 2008/03/23 14:48:54
dnl ---------------
dnl Look for a non-standard library, given parameters for AC_TRY_LINK.  We
dnl prefer a standard location, and use -L options only if we do not find the
dnl library in the standard library location(s).
dnl	$1 = library name
dnl	$2 = library class, usually the same as library name
dnl	$3 = includes
dnl	$4 = code fragment to compile/link
dnl	$5 = corresponding function-name
dnl	$6 = flag, nonnull if failure should not cause an error-exit
dnl
dnl Sets the variable "$cf_libdir" as a side-effect, so we can see if we had
dnl to use a -L option.
AC_DEFUN([CF_FIND_LIBRARY],
[
	eval 'cf_cv_have_lib_'$1'=no'
	cf_libdir=""
	AC_CHECK_FUNC($5,
		eval 'cf_cv_have_lib_'$1'=yes',[
		cf_save_LIBS="$LIBS"
		AC_MSG_CHECKING(for $5 in -l$1)
		LIBS="-l$1 $LIBS"
		AC_TRY_LINK([$3],[$4],
			[AC_MSG_RESULT(yes)
			 eval 'cf_cv_have_lib_'$1'=yes'
			],
			[AC_MSG_RESULT(no)
			CF_LIBRARY_PATH(cf_search,$2)
			for cf_libdir in $cf_search
			do
				AC_MSG_CHECKING(for -l$1 in $cf_libdir)
				LIBS="-L$cf_libdir -l$1 $cf_save_LIBS"
				AC_TRY_LINK([$3],[$4],
					[AC_MSG_RESULT(yes)
			 		 eval 'cf_cv_have_lib_'$1'=yes'
					 break],
					[AC_MSG_RESULT(no)
					 LIBS="$cf_save_LIBS"])
			done
			])
		])
eval 'cf_found_library=[$]cf_cv_have_lib_'$1
ifelse($6,,[
if test $cf_found_library = no ; then
	AC_MSG_ERROR(Cannot link $1 library)
fi
])
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_FIND_TDLIB version: 7 updated: 2009/01/06 19:42:31
dnl -------------
dnl Locate TD_LIB, which is either installed, with headers, library and
dnl include-file for make, or in a directory side-by-side with the current
dnl program's configure script. Use the side-by-side version in preference
dnl to the installed version, to facilitate development.
dnl
dnl Sets:
dnl	TD_LIB_rules - actual path of td_lib.mk
dnl
AC_DEFUN([CF_FIND_TDLIB],
[
AC_REQUIRE([CF_LIB_PREFIX])
AC_MSG_CHECKING(for td_lib in side-by-side directory)
AC_CACHE_VAL(cf_cv_tdlib_devel,[
	cf_cv_tdlib_devel=no

	test -d ../td_lib &&
	test -d ../td_lib/include &&
	test -f ../td_lib/include/td_config.h &&
	test -d ../td_lib/lib &&
	test -f ../td_lib/lib/${LIB_PREFIX}td.a &&
	cf_cv_tdlib_devel=yes

	if test "$cf_cv_tdlib_devel" = yes ; then
		cf_save_CFLAGS="$CFLAGS"
		cf_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS -I`cd ../td_lib/include;pwd`"
		LIBS="-L`cd ../td_lib/lib;pwd` $LIBS"
		TD_LIB_rules=`cd ../td_lib/support;pwd`
	fi
])
AC_MSG_RESULT($cf_cv_tdlib_devel)

if test "$cf_cv_tdlib_devel" = no ; then
    CF_HEADER_PATH(cf_search,td)
    # get all matches, since we're including <ptypes.h> and <td/ptypes.h>
    for cf_incdir in $cf_search
    do
	test -f $cf_incdir/td/td_config.h && CFLAGS="$CFLAGS -I$cf_incdir"
    done
    CF_FIND_LIBRARY(td,td,[
#define TESTING_CONFIG_H
#include <td/ptypes.h>],[
        char *p = doalloc(0,1)],
        doalloc)
	if test -z "$cf_libdir" ; then
		CF_LIBRARY_PATH(cf_search,td)
		cf_libdir=/usr/local/lib
		cf_td_lib_rules=no
		for cf_libdir in $cf_search
		do
			if test -f $cf_libdir/td_lib.mk ; then
				cf_td_lib_rules=yes
				break
			fi
		done
		test $cf_td_lib_rules = no && AC_MSG_ERROR(Cannot find td_lib.mk)
	fi
	TD_LIB_rules=$cf_libdir
fi

AC_SUBST(TD_LIB_rules)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_HEADER_PATH version: 9 updated: 2008/12/07 19:38:31
dnl --------------
dnl Construct a search-list of directories for a nonstandard header-file
dnl
dnl Parameters
dnl	$1 = the variable to return as result
dnl	$2 = the package name
AC_DEFUN([CF_HEADER_PATH],
[
cf_header_path_list=""
if test -n "${CFLAGS}${CPPFLAGS}" ; then
	for cf_header_path in $CPPFLAGS $CFLAGS
	do
		case $cf_header_path in #(vi
		-I*)
			cf_header_path=`echo ".$cf_header_path" |sed -e 's/^...//' -e 's,/include$,,'`
			CF_ADD_SUBDIR_PATH($1,$2,include,$cf_header_path,NONE)
			cf_header_path_list="$cf_header_path_list [$]$1"
			;;
		esac
	done
fi

CF_SUBDIR_PATH($1,$2,include)

test "$includedir" != NONE && \
test "$includedir" != "/usr/include" && \
test -d "$includedir" && {
	test -d $includedir &&    $1="[$]$1 $includedir"
	test -d $includedir/$2 && $1="[$]$1 $includedir/$2"
}

test "$oldincludedir" != NONE && \
test "$oldincludedir" != "/usr/include" && \
test -d "$oldincludedir" && {
	test -d $oldincludedir    && $1="[$]$1 $oldincludedir"
	test -d $oldincludedir/$2 && $1="[$]$1 $oldincludedir/$2"
}

$1="$cf_header_path_list [$]$1"
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_LIBRARY_PATH version: 8 updated: 2008/12/07 19:38:31
dnl ---------------
dnl Construct a search-list of directories for a nonstandard library-file
dnl
dnl Parameters
dnl	$1 = the variable to return as result
dnl	$2 = the package name
AC_DEFUN([CF_LIBRARY_PATH],
[
cf_library_path_list=""
if test -n "${LDFLAGS}${LIBS}" ; then
	for cf_library_path in $LDFLAGS $LIBS
	do
		case $cf_library_path in #(vi
		-L*)
			cf_library_path=`echo ".$cf_library_path" |sed -e 's/^...//' -e 's,/lib$,,'`
			CF_ADD_SUBDIR_PATH($1,$2,lib,$cf_library_path,NONE)
			cf_library_path_list="$cf_library_path_list [$]$1"
			;;
		esac
	done
fi

CF_SUBDIR_PATH($1,$2,lib)

$1="$cf_library_path_list [$]$1"
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_LIB_PREFIX version: 8 updated: 2008/09/13 11:34:16
dnl -------------
dnl Compute the library-prefix for the given host system
dnl $1 = variable to set
AC_DEFUN([CF_LIB_PREFIX],
[
	case $cf_cv_system_name in #(vi
	OS/2*|os2*) #(vi
        LIB_PREFIX=''
        ;;
	*)	LIB_PREFIX='lib'
        ;;
	esac
ifelse($1,,,[$1=$LIB_PREFIX])
	AC_SUBST(LIB_PREFIX)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_MAKE_AR_RULES version: 4 updated: 2008/03/23 14:48:54
dnl ----------------
dnl Check if the 'make' program knows how to interpret archive rules.  Though
dnl this is common practice since the mid-80's, there are some holdouts (1997).
AC_DEFUN([CF_MAKE_AR_RULES],
[
AC_MSG_CHECKING(if ${MAKE-make} program knows about archives)
AC_CACHE_VAL(cf_cv_ar_rules,[
cf_dir=subd$$
cf_cv_ar_rules=unknown
mkdir $cf_dir
cat >$cf_dir/makefile <<CF_EOF
SHELL = /bin/sh
AR = ar crv
CC = $CC

.SUFFIXES:
.SUFFIXES: .c .o .a

all:  conf.a

.c.a:
	\$(CC) -c $<
	\$(AR) \$[]@ \$[]*.o
conf.a : conf.a(conftest.o)
CF_EOF
touch $cf_dir/conftest.c
CDPATH=; export CDPATH
if ( cd $cf_dir && ${MAKE-make} 2>&AC_FD_CC >&AC_FD_CC && test -f conf.a )
then
	cf_cv_ar_rules=yes
else
echo ... did not find archive >&AC_FD_CC
rm -f $cf_dir/conftest.o
cat >$cf_dir/makefile <<CF_EOF
SHELL = /bin/sh
AR = ar crv
CC = $CC

.SUFFIXES:
.SUFFIXES: .c .o

all:  conf.a

.c.o:
	\$(CC) -c $<

conf.a : conftest.o
	\$(AR) \$[]@ \$?
CF_EOF
CDPATH=; export CDPATH
if ( cd $cf_dir && ${MAKE-make} 2>&AC_FD_CC >&AC_FD_CC && test -f conf.a )
then
	cf_cv_ar_rules=no
else
	AC_MSG_ERROR(I do not know how to construct a library)
fi
fi
rm -rf $cf_dir
])
AC_MSG_RESULT($cf_cv_ar_rules)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_MAKE_INCLUDE version: 8 updated: 2008/03/23 14:48:54
dnl ---------------
dnl Check for the use of 'include' in 'make' (BSDI is a special case)
dnl The symbol $ac_make is set in AC_MAKE_SET, as a side-effect.
AC_DEFUN([CF_MAKE_INCLUDE],
[
AC_MSG_CHECKING(for style of include in makefiles)

make_include_left=""
make_include_right=""
make_include_quote="unknown"

cf_inc=head$$
cf_dir=subd$$
echo 'RESULT=OK' >$cf_inc
mkdir $cf_dir

for cf_include in "include" ".include" "!include"
do
	for cf_quote in '' '"'
	do
		cat >$cf_dir/makefile <<CF_EOF
SHELL=/bin/sh
${cf_include} ${cf_quote}../$cf_inc${cf_quote}
all :
	@echo 'cf_make_include=\$(RESULT)'
CF_EOF
	cf_make_include=""
	CDPATH=; export CDPATH
	eval `(cd $cf_dir && ${MAKE-make}) 2>&AC_FD_CC | grep cf_make_include=OK`
	if test -n "$cf_make_include"; then
		make_include_left="$cf_include"
		make_include_quote="$cf_quote"
		break
	else
		echo Tried 1>&AC_FD_CC
		cat $cf_dir/makefile 1>&AC_FD_CC
	fi
	done
	test -n "$cf_make_include" && break
done

rm -rf $cf_inc $cf_dir

if test -z "$make_include_left" ; then
	AC_MSG_ERROR(Your $ac_make program does not support includes)
fi
if test ".$make_include_quote" != .unknown ; then
	make_include_left="$make_include_left $make_include_quote"
	make_include_right="$make_include_quote"
fi

AC_MSG_RESULT(${make_include_left}file${make_include_right})

AC_SUBST(make_include_left)
AC_SUBST(make_include_right)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_PATHSEP version: 4 updated: 2009/01/11 20:30:23
dnl ----------
dnl Provide a value for the $PATH and similar separator
AC_DEFUN([CF_PATHSEP],
[
	case $cf_cv_system_name in
	os2*)	PATH_SEPARATOR=';'  ;;
	*)	PATH_SEPARATOR=':'  ;;
	esac
ifelse($1,,,[$1=$PATH_SEPARATOR])
	AC_SUBST(PATH_SEPARATOR)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_PROGRAM_FULLPATH version: 5 updated: 2009/01/11 20:30:23
dnl -------------------
dnl Tests for one or more programs given by name along the user's path, and
dnl sets a variable to the program's full-path if found.
AC_DEFUN([CF_PROGRAM_FULLPATH],
[
AC_REQUIRE([CF_PATHSEP])
AC_REQUIRE([CF_PROG_EXT])
AC_MSG_CHECKING(full path of $1)
AC_CACHE_VAL(cf_cv_$1,[
	cf_cv_$1="[$]$1"
	if test -z "[$]cf_cv_$1"; then
		set -- $2;
		while test [$]# != 0; do
			cf_word=[$]1${PROG_EXT}
			case [$]1 in
			-*)
				;;
			*)
				if test -f "$cf_word" && test ! -f "./$cf_word" && test -x "$cf_word"; then
					cf_cv_$1="$cf_word"
				else
					IFS="${IFS= 	}"; cf_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR}"
					for cf_dir in $PATH; do
						test -z "$cf_dir" && cf_dir=.
						if test "$cf_dir" != "." && test -f $cf_dir/$cf_word && test -x $cf_dir/$cf_word; then
							cf_cv_$1="$cf_dir/$cf_word"
							break
						fi
					done
					IFS="$cf_save_ifs"
				fi
				if test -n "[$]cf_cv_$1"; then
					shift
					break
				fi
				;;
			esac
			shift
		done
	fi
	# append options, if any
	if test -n "[$]cf_cv_$1"; then
		while test [$]# != 0; do
			case [$]1 in
			-[*]) cf_cv_$1="[$]cf_cv_$1 [$]1";;
			[*])  set -- end;;
			esac
			shift
		done
	fi
])
if test -n "[$]cf_cv_$1"; then
	AC_DEFINE_UNQUOTED($1,"[$]cf_cv_$1")
  AC_MSG_RESULT("[$]cf_cv_$1")
else
  AC_MSG_RESULT((not found))
fi
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_SRC_MAKEFILE version: 2 updated: 1997/09/13 01:16:12
dnl ---------------
dnl Append predefined lists to $2/makefile, given a path to a directory that
dnl has a 'modules' file in $1.
dnl
dnl The library is named $Z, to avoid problems with parentheses.
AC_DEFUN([CF_SRC_MAKEFILE],
[
cf_mod=$1/$2/modules
cf_out=$2/makefile
if test -f $cf_mod ; then
${AWK-awk} <$cf_mod >>$cf_out '
BEGIN	{
		found = 0;
	}
	{
		if ( found == 0 )
		{
			printf "\nCSRC="
			found = 1;
		}
		printf " \\\n\t%s.c", [$]1
	}
END	{
		print ""
	}
'
	if test $cf_cv_ar_rules = yes ; then
${AWK-awk} <$cf_mod >>$cf_out '
BEGIN	{
		found = 0;
	}
	{
		if ( found == 0 )
		{
			printf "\nOBJS="
			found = 1;
		}
		printf " \\\n\t$Z(%s.o)", [$]1
	}
END	{
		print ""
	}
'
	else
${AWK-awk} <$cf_mod >>$cf_out '
BEGIN	{
		found = 0;
	}
	{
		if ( found == 0 )
		{
			printf "\nOBJS="
			found = 1;
		}
		printf " \\\n\t%s.o", [$]1
	}
END	{
		print ""
	}
'
	fi
ifelse($3,,,[
	cat >>$cf_out <<CF_EOF


${make_include_left}$3${make_include_right}
CF_EOF
])
test -f $1/$2/makefile.2nd && \
    cat $1/$2/makefile.2nd >>$2/makefile

	if test $cf_cv_ar_rules = yes ; then
cat >>$cf_out <<CF_EOF

\$Z:	\$(OBJS)
	\$(RANLIB) \$Z
CF_EOF
	else
cat >>$cf_out <<CF_EOF

\$Z:	\$(OBJS)
	\$(AR) \$Z \$(OBJS)
	\$(RANLIB) \$Z
CF_EOF
	fi
fi
test -f $1/$2/makefile.end && \
    cat $1/$2/makefile.end >>$2/makefile
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_SUBDIR_PATH version: 5 updated: 2007/07/29 09:55:12
dnl --------------
dnl Construct a search-list for a nonstandard header/lib-file
dnl	$1 = the variable to return as result
dnl	$2 = the package name
dnl	$3 = the subdirectory, e.g., bin, include or lib
AC_DEFUN([CF_SUBDIR_PATH],
[$1=""

CF_ADD_SUBDIR_PATH($1,$2,$3,/usr,$prefix)
CF_ADD_SUBDIR_PATH($1,$2,$3,$prefix,NONE)
CF_ADD_SUBDIR_PATH($1,$2,$3,/usr/local,$prefix)
CF_ADD_SUBDIR_PATH($1,$2,$3,/opt,$prefix)
CF_ADD_SUBDIR_PATH($1,$2,$3,[$]HOME,$prefix)
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_UPPER version: 5 updated: 2001/01/29 23:40:59
dnl --------
dnl Make an uppercase version of a variable
dnl $1=uppercase($2)
AC_DEFUN([CF_UPPER],
[
$1=`echo "$2" | sed y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%`
])dnl
dnl ---------------------------------------------------------------------------
dnl CF_VERBOSE version: 3 updated: 2007/07/29 09:55:12
dnl ----------
dnl Use AC_VERBOSE w/o the warnings
AC_DEFUN([CF_VERBOSE],
[test -n "$verbose" && echo "	$1" 1>&AC_FD_MSG
CF_MSG_LOG([$1])
])dnl
