.\" $Id: copy.man,v 11.13 2014/12/15 21:42:53 tom Exp $
.de Es
.ne \\$1
.nr mE \\n(.f
.RS 5n
.sp .7
.nf
.nh
.ta 9n 17n 25n 33n 41n 49n
.ft CW
..
.de Ex
.ft \\n(mE
.fi
.hy \\n(HY
.RE
.sp .7
..
.TH COPY 1
.SH NAME
.PP
\fBcopy\fR \- file/directory copy utility
.SH USAGE
.PP
.BI copy " [options] file1 file2"
.PP
.BI copy " [options] file ... directory"
.SH SYNOPSIS
.PP
\fBCopy\fR is an extension of the basic POSIX \fBcp\fR utility.
It copies files, preserving their modification date.
.SH DESCRIPTION
.PP
\fBCopy\fR copies \fIfile1\fR onto \fIfile2\fR.
It preserves
the existing mode of \fIfile2\fR.
If \fIfile2\fR did not
exist, \fBcopy\fR uses the mode of the source file.
.PP
\fBCopy\fR can also be used to copy one or more files into
\fIdirectory\fR, without changing their original filenames.
It refuses to copy
a file onto itself.
.PP
Except for symbolic links, \fIfile2\fR will be set to
the same modification date as \fIfile1\fR.
The owner of the file
will be the same as the owner of the process which invokes \fBcopy\fR.
Unless the "\-\fBi\fR" option is used, \fBcopy\fR ignores
permissions of the (previous) destination file.
.SH OPTIONS
.PP
\fBCopy\fR recognizes options similar to those of \fBcp\fR,
but with extensions:
.TP 4n
.B \-a
include dot-files (names beginning with '.').
This is the default.
Use this option to override \fB\-z\fP,
e.g., in a script which presets that option.
.TP
.B \-d
all names given are treated as the destination; the
source names are obtained by taking the leaves and looking for them
in the current working directory.
This is provided to simplify installation
of files in a directory.
.TP
.B \-f
forces copy into protected directories by temporarily changing the
destination protection.
.TP
.B \-i
prompt with the name of the file whenever the copy
will cause an old file to be overwritten.
A "y" answer causes
copy to continue.
Any other answer prevents it from overwriting the
file.
.TP
.B \-l
copy the files which symbolic links point to, rather
than copying the links themselves.
.TP
.B \-m
permits you to merge directories.
If the source
and destination are directories, \fBcopy\fR will normally create
a new directory under the destination with the same leaf name as the
source.
For example,
.Es
copy /local/bin /usr/local/bin
.Ex
.IP
will create and copy into the directory "/usr/local/bin/bin"
if "/usr/local/bin" exists.
Use the "\-\fBm\fR" option
to copy onto an existing directory.
.RE
.TP
.B \-n
disables the actual creation or modification
of files, and (depending on the level of verboseness) shows the effect
which the \fBcopy\fR command would have.
.TP
.B \-p
attempt to preserve file ownership.
.TP
.B \-s
enables the set-uid and set-gid file modes in
the target.
.TP
.B \-u
copies files only if their size or modification date differs,
and links only if the link-text differs.
.TP
.B \-U
copies only files that are newer than the destination, or that
do not exist in the destination.
.TP
.B \-v
verbose mode directs \fBcopy\fR to print the
names (to standard error) of the files which it copies.
.TP
.B \-z
omit dot-files (names beginning with '.').
.TP
.B \-S
(Linux only) tells \fBcopy\fR that the source is on a filesystem using local
time, and
that appropriate adjustments must be made in the timestamp computation.
.TP
.B \-D
(Linux only) tells \fBcopy\fR that the destination is on a filesystem using
local time, and
that appropriate adjustments must be made in the timestamp computation.
.SH OPERATIONS
.PP
\fBCopy\fR is used exactly as one would use \fBcp\fR (for
file-copying).
Directory copying is performed without the "\-\fBr\fR"
option of \fBcp\fR.
.PP
\fBCopy\fR recognizes the C-shell "~" (tilde) to denote the
home directory of POSIX users.
.PP
If more than two arguments are given, or if the destination ends with
"/", \fBcopy\fR assumes that the user wants to write into an
existing directory rather than create a new one.
.SH ENVIRONMENT
.PP
\fBCopy\fR is a C-language program which runs in a POSIX environment.
.SH FILES
.PP
\fBCopy\fR is a single binary file, "copy".
.SH ANTICIPATED CHANGES
.PP
\fBCopy\fR does not currently know how to handle special files
(e.g., \fB/dev/tty\fR).
.SH SEE ALSO
.PP
cp\ (1)
.SH AUTHOR:
.PP
Thomas E. Dickey <dickey@invisible-island.net>
