/************************************************************************/
/* 									*/
/* FileViewer.cc: Implementation of the FileViewer class		*/
/*		  This class creates the file viewer window and		*/
/*		  handles all events in it.				*/
/*		  Roland Krause 1998					*/
/*									*/
/************************************************************************/

// --- Include ----------------------------------------------------------

#include <stdio.h>

#include <X11/Intrinsic.h>		// Header of Xt
#include <X11/StringDefs.h>		// Ressource definitions

// Header of XawPlus

#include <X11/Shell.h>
#include <X11/XawPlus/Paned.h>		// The panel widget
#include <X11/XawPlus/AsciiText.h>	// The widget for the file list
#include <X11/XawPlus/Command.h>	// The command widget for the buttons

// Class definition of this class

#include "FileViewer.h"


// --- Implementation of callbacks -------------------------------------

// The callbacks are not part of this class ! They are only a part of
// this module. That is the reason why all callbacks works on objects.
// Since the callbacks are defined static, they are not visibile outside
// of this module.

// **********************************************************************
//
// CloseWin():	   Callback to close this file viewer window
//
// Arguments:	   clientData - Contains pointer to the file viwer
//				object
//
// **********************************************************************

static void CloseWin(Widget w, XtPointer clientData, XtPointer callData)
{
  FileViewer *fw = (FileViewer *)clientData;

  delete(fw);
}


// --- Implementation of public class methods ---------------------------

// **********************************************************************
//
// FileViewer(): The constructor of this class
//		 Creates the file viewer window
//
// Arguments:	 rootShell - The root shell widget of this application
//		 ID	   - An ID number for this viewer
//		 FileName  - Name of the file to view here
//		 File	   - The data of the file to view
//
// **********************************************************************

FileViewer::FileViewer(Widget rootShell, int ID, char *FileName, char* File)
{
   char   NameOfMyShell[80];
   Widget viewerPanel, doneButton;

// At first we create the viewer shell and base panel

  (void)sprintf(NameOfMyShell, "viewerShell_%d", ID);
  viewerShell=  XtVaCreatePopupShell(NameOfMyShell, applicationShellWidgetClass, rootShell,
		XtNallowShellResize, TRUE, XtNtitle, FileName, NULL);

   viewerPanel= XtVaCreateManagedWidget("viewerPanel", panedWidgetClass, viewerShell, NULL);

// Now we create the widgets on the base panel

   (void)	XtVaCreateManagedWidget("viewer", asciiTextWidgetClass, viewerPanel,
		XtNshowGrip, FALSE, XtNeditType, XawtextRead,
		XtNstring, File, NULL);

   doneButton=	XtVaCreateManagedWidget("done", commandWidgetClass, viewerPanel,
		XtNshowGrip, FALSE, XtNskipAdjust, TRUE, NULL);
   XtAddCallback(doneButton, XtNcallback, CloseWin, (XtPointer)this);

   XtPopup(viewerShell, XtGrabNone);
}

// **********************************************************************
//
// ~FileViewer(): The destructor of this class
//		  Destroy the file viewer window
//
// **********************************************************************

FileViewer::~FileViewer(void)
{
  XtPopdown(viewerShell);
  XtDestroyWidget(viewerShell);
}









