.TH Xe 1 "2 November 1997" "X Version 11"
.SH NAME
xe - A simple text editor for the X window system

.SH SYNTAX
\fBxe\fR [\fItoolkit options\fR] [\fIfilename\fR]

.SH OPTIONS
\fBxe\fR accepts all of the standard X Toolkit command line
options (see \fIX(1)\fP). The order of the command line options is
not important.
.IP \fBfilename\fR
Specifies the file loaded by \fBxe\fR during start up. This is the
file which will be edited. \fBxe\fR does not create files during start up!
.PP

.SH DESCRIPTION
The window of \fBxe\fR consists of two areas. The upper area
contains the buttons \fBQuit\fR, \fBClose\fR, \fBLoad\fR, \fBNew\fR,
\fBSave\fR, \fBSave As\fR and a text label for additional informations,
i.e. the name of the file you are working with. 

The second area contains the edit window for your text. This
working area based on the Athena Text widget and uses the same
control mechanism as \fBxedit\fR.

.SH BUTTONS
\fBxe\fR has some buttons to control its function:
.IP \fBQuit\fR
Terminates \fBxe\fR.
.IP \fBClose\fR
Press this button to close an opened file. It is not possible
to load or to create a file without closing the old file.
.IP \fBLoad\fR
Press this button to load a file. \fBLoad\fR activates the
\fILoad File\fR dialogue to select a file to load. This dialogue
displays a `ls -l' styled file list of the current working
directory. To change the directory press a directory name, marked
with a folder icon in the first column. Select directory `.' to redisplay
the files in the current directory, select `..' to change one step
upward in the directory hierarchy or select any other file to edit
it. After this, press \fBOk\fR to open this file or \fBCancel\fR
to abort the dialogue. Note, that the \fILoad File\fR dialogue
does not display special files like device drivers or named pipes
because ist is not possible to edit them.
Executable files are displayed with a gear wheel icon in the first
column. Not readable files are displayed
with a shaded sheet of paper as icon and directories that are
not executable are displayed with a shaded folder icon.
.IP \fBNew\fR
Creates a new file for editing. After creating the new file has
no name. Store the file with \fBSave As\fR.
.IP \fBLine\fR
Press this button, if you want to jump to a defines line number
in your openend file. \fBLine\fR activates the \fIGoto Line\fR
dialogue to select a line number to jump to. Press \fBOk\fR 
or simply type <CR> in the text line to jump to the specified line.
Otherwise press \fBCancel\fR to abort.
.IP \fBSave\fR
Press \fBSave\fR to store your modifications. If the file has
no name, \fBSave\fR activates the \fBSave As\fR dialogue.
.IP "\fBSave As\fR"
Press \fBSave As\fR to store the opened file with a new file name.
This option is required, if you create a new file with \fBNew\fR.
.PP

.SH THE EDIT WINDOW
\fBxe\fR uses as \fBxedit\fR the Athena Text widget for his edit window.
So both applications share the same mechanism to work with a text.
By default, the edit window has a vertical and a
horizontal scrollbar if needed. It is possible to override these
ressources.

\fBxe\fR's default keystrokes closely resemble those of the MicroEMACS editor
and exactly those of \fBxedit\fR.
Some of the default keystrokes are as follows:
.IP \fB<ctrl-K>\fR 1.5i
Kill text from the cursor to the end of the line.
.IP \fB<ctrl-R>\fR 1.5i
Search and replace backwards.
.IP \fB<ctrl-S>\fR 1.5i
Search and replace forward.
.IP \fB<ctrl-W>\fR 1.5i
Kill the selection made with the mouse.
.IP \fB<ctrl-Y>\fR 1.5i
Yank text -- copy back text that had been killed.
.IP \fB<alt-I>\fR 1.5i
Insert a file at the current cursor position. Note that this only works,
if you have write permissions to the opened file.
.PP

This is a very uncomplete list. Look for the description of the
\fBAthena Text widget\fR for a complete list.
.br
In addition, you can use the X system's default cut-and-paste feature, as
follows:

.ta 0.5i 2.5i
	Left Button Down	Start selection
.br
	Left Button Motion	Sweep out selection
.br
	Left Button Up	End selection (i.e., cut)
.br
	Middle Button Down	Insert current selection (paste)
.br
	Right Button Down	Extend current selection
.br
	Right Button Motion	Adjust selection
.br
	Right Button Up	End selection (cut)
.br

If your mouse has only two  buttons, press both buttons to mimic the middle
mouse button.  Note that this only  works if you have un-commented the line
emulate3buttons in the file /usr/X11/lib/Xconfig.

.SH RESSOURCES
\fBxe\fR uses the following additional resources for foreign
language support:
.IP "\fBcreateListErr\fR(class \fBXeMessage\fR)"
\fBxe\fR display this text, if it is not possible to create
a list of files in the current working directory. Default is 
\fI"Cannot create file list !"\fR
.IP "\fBalreadyOpenErr\fR(class \fBXeMessage\fR)"
It is not possible to open more than one file at a time.
If you try it, \fBxe\fR displays by default the following
message: \fI"Please close the file first !"\fR
.IP "\fBopenFileErr\fR(class \fBXeMessage\fR)"
If it is not possible to open the selected file \fBxe\fR
displays the message \fI"Cannot open file !"\fR
.IP "\fBwriteErr\fR(class \fBXeMessage\fR)"
If \fBxe\fR don't have write permissions, the following
messages appears: \fI"Cannot write file !"\fR
.IP "\fBreadOnlyMsg\fR(class \fBXeMessage\fR)"
If the opend file is read only, \fBxe\fR displays the
following message: \fI"File is read only !"\fR
.IP "\fBnewFileMsg\fR(class \fBXeMessage\fR)"
If a new file is created via pressing the new button, \fBxe\fR
displays the following message: \fI"New file"\fR
.IP "\fBnotSelectMsg\fR(class \fBXeMessage\fR)"
\fBxe\fR displays \fI"No file selected !"\fR, if the \fBOk\fR button
is pressed in the file dialogue without selecting a file.

.SH SEE ALSO
\fBxedit\fR, \fBxed\fR

.SH AUTHOR
\fBxe\fR is written by Roland Krause in 1996 and 1997 for all SVR4 based systems.



