/************************************************************************/
/* 									*/
/* 	MainWin.h: Definition of the MainWin class			*/
/*		   This class creates the main window and handles all	*/
/*		   events in it.					*/
/*		   Roland Krause 1998, 1999				*/
/*									*/
/************************************************************************/

#ifndef MAINWIN_H
#define MAINWIN_H

// --- Include ----------------------------------------------------------

#include <X11/Intrinsic.h>	// Header of Xt

#include "ExtrDialog.h"		// To create the file extraction dialog
#include "FileSelect.h"		// File handling


// --- Class definition -------------------------------------------------

class MainWin
{
  private:

	char	*StartSel, *EndSel,		// Selected area in the tar list
		*CurrPosition;			// used by GetSelection(), GetNextSelection()

	// Work procedures and callbacks for this class

	friend Boolean ViewNextFile(XtPointer);
	friend void EndOfProg(Widget, XtPointer, XtPointer);
	friend void OpenDialog(Widget, XtPointer, XtPointer);
	friend void ViewFile(Widget, XtPointer, XtPointer);
	friend void ExtractFile(Widget, XtPointer, XtPointer);

  protected:

	// The widgets of the main window

	Widget	mainShell,			// The shell of this window
		tarList,			// List for filnames of a tar archive
		message,			// A label for messages
		quitButton,			// The quit button
		newButton,			// Create a new archive
		openButton,			// Open an archive
		extract,			// extract files from archive
		extrAll,			// Extract all file from archive
		viewButton;			// The view button

  	int	shellNumber;			// Number of viewer shell

	FileSelect *fileDialog;			// File dialog object
	ExtrDialog *extrDialog;			// Extraction dialog object

  	inline void GetPosition(int *x, int *y);// Determine current window position
  	char *GetSelection(void);		// Get selection in tar list
  	char *GetNextSelection(void);		// Get next entry after a GetSelection()
  	char *GetCompleteSelection(void);	// Get all selected files

  public:

  	MainWin(Widget shell, FileSelect *selector, ExtrDialog *dialog);
  	void RunIt(XtAppContext app, Widget shell, char *ArchFile);
};

#endif

