/************************************************************************/
/* 									*/
/* HandleTar.h: Definition of the HandleTar class			*/
/*		This class handles the communication with tar		*/
/*		Roland Krause 1998					*/
/*									*/
/************************************************************************/

#ifndef HANDLETAR_H
#define HANDLETAR_H

// --- Include ----------------------------------------------------------

#include <stdio.h>


// --- Definitions ------------------------------------------------------

typedef enum { Unknown, IsCompressed, NotCompressed } CompType;

#define TAR_PATH_LEN	200		// Maximum length of Pathnames
#define TAR_CHECK_FILES	30		// # of files to read while checking
#define TAR_READ_FILES	200		// # of files while reading the content

// Tar commands to get file lists

#define TAR_LIST	"tar tvf %s 2>/dev/null"
#define TAR_LIST_COMP	"tar tvzf %s 2>/dev/null"

// Tar commands to extract files to /tmp

#define TAR_EXTR	"cd /tmp; tar xf %s %s 2>&1 >/dev/null"
#define TAR_EXTR_COMP	"cd /tmp; tar xzf %s %s 2>&1 >/dev/null"

// Tar commands to extract files with a given path name

#define TAR_EXTR_PATH	"cd %s; tar xf %s %s 2>&1 >/dev/null"
#define TAR_EXTR_C_PATH	"cd %s; tar xzf %s %s 2>&1 >/dev/null"


// --- Class definition -------------------------------------------------

class HandleTar
{
  private:
	FILE		*TarStream;	// A pipe to tar
	int		ContLineCounter;// Number of lines already read
	int		ReadLines;
	int		ListLength;	// Length of the list
	char		*ContentList;	// Pointer to the list
	CompType	Compressed;	// tar archive compressed or not ?

 protected:
	char FileName[TAR_PATH_LEN];	// The name of the tar file

	int CheckContentList(char *tarCommand);

  public:

	HandleTar(char *FName);		// The constructor of this class
	~HandleTar(void);		// The destructor

	// Handling of the content list of an archive

	int   CheckContent(char **list);// Try to open the archive
	int   ReadContent(char **list);	// Read the content list
	void  DeleteContent(void);	// Release all resources

	char *GetFile(char *File);	// Load a file from the tar archive into memory
					// Extract file from the tar archive
	void ExtractFiles(char *FileList, char *Path);
};

#endif


