.TH PIXMAP 1 "XawPlus 3.0" "X Version 11"
.SH NAME
pixmap \- Xpm pixmap editor for X
.SH SYNOPSIS
.B pixmap
[-options ...]
.sp
.SH DESCRIPTION
The \fIpixmap\fP program is a tool for creating or editing
rectangular images made up of colored pixels, i.e., pixmaps. Pixmaps
are intensively used in X to define window backgrounds, icon images, etc.
.PP
The \fIpixmap\fP program can have two different interfaces, a Athena
widgets version and a Motif widgets version.
.SH USAGE
\fIPixmap\fP displays grid in which each square represents a single pixel in
the picture being edited.  Squares can be set, cleared, or inverted
(this last operation will be detailed later) directly
with the buttons on the pointer and a menu of higher level operations such
as draw line and fill circle is provided to the side of the grid.
Another menu on the top of the window allows files operations (Load,
Save, ...), edit operations (Cut/Copy/Paste, attributes of pixmap
editing, ...) and colors operations (drawing color, attributes of
colors, ...). \fIPixmap\fP uses a Pixmap widget to represent the
pixmap image. 
.PP
Pixmaps are stored as a C string array variable suitable for including in 
applications, using the format defined by Arnaud Le Hors in his Xpm
library (refer to Xpm manual for format description). This format
allows pixmaps to be used indistinctly on monochrome, grey
scale or color displays.
.SH "OPTIONS"
.PP
\fIPixmap\fP accepts the following command line options:
.TP 4
.B \-display/\-d \fIdisplay\fP
This option specifies the name of the X server to use.
.TP 4
.B \-geometry \fIgeometry\fP
This option specifies the placement and size of the \fIpixmap\fP
program window on the screen.  See \fIX\fP for details.
.TP 4
.B \-help/\-h
This option asks for the usage description of \fIpixmap\fP.
.TP 4
.B \-size \fIWIDTHxHEIGHT\fP
This option specifies the size (width and height) in pixels of the
pixmap to be edited.
.TP 4
.B \-squares \fISIZE\fP
This option specifies the size in display points to use to represent
each pixel (a square of SIZE points).
.TP 4
.B +grid/\-grid
This option indicates that the grid lines in the Pixmap widget
should be displayed or not. 
.TP 4
.B \-stippled
This option turns off stipple drawing of transparent pixels.
.TP 4
.B \-stipple \fIpixmap\fP
This option specifies the depth 1 pixmap to use to draw transparent pixels.
.TP 4
.B +axes/\-axes
This option indicates that the axes in the Pixmap widget should be
displayed or not.
.TP 4
.B +proportional/\-proportional
This option indicates that the pixels in the Pixmap widget should
be drawn proportional, i.e. in squares,  or not.
.TP 4
.B \-hl \fIcolor\fP
This option specifies the color to use for highlighting purposes.
\fIcolor\fP can be any name accepted by the XParseColor(3X11) function.
.TP 4
.B \-fr \fIcolor\fP
This option specifies the color to use draw grid and axes in Pixmap widget.
\fIcolor\fP can be any name accepted by the XParseColor(3X11) function.
.TP 4
.B \-tr \fIcolor\fP
This option specifies the color to use to represent transparent pixels.
\fIcolor\fP can be any name accepted by the XParseColor(3X11) function.
.TP 4
.B \-fn/\-font \fIfontname\fP
This option specifies the font to be used in \fIpixmap\fP.
.TP 4
.B \-filename/\-f/\-in \fIfilename\fP
This option specifies the name of the file from which the pixmap to be
edited should be loaded.
.TP 4
.B \-colormap/\-pc
This options specifies that pixmap should use its own private colormap
instead of the default colormap.
.SH PIXELS EDITING WITH MOUSE
Pixels may be set, cleared, or inverted by pointing to them and
clicking one of the buttons indicated below.  Multiple pixels can be
changed at once by holding the button down and dragging the cursor
across them.  Set pixels are filled with the current color; cleared
pixels are filled with white; and inverted pixels are either set if
they were originally cleared or cleared otherwise.
.RS .5in
.TP 4
.I "Button 1"
.br
This button (usually leftmost on the pointer) is used to set one or 
more pixels.
.TP 4
.I "Button 2"
.br
This button (usually in the middle) is used to invert one or more pixels.
.TP 4
.I "Button 3"
.br
This button (usually on the right) is used to clear one or more pixels.
.RE

Every button operation can be changed by means of resources in the
\.Xdefaults file or application defaults file
(/usr/X11/lib/X11/app-defaults/Pixmap).
.SH MENU COMMANDS
To make defining shapes easier, \fIpixmap\fP provides several commands for
drawing and manipulating the pixmap edited, and commands for file management.
.PP
Commands are layed in a vertical bar at the left of the Pixmap widget
and in a menu bar at the top of the window. Most of the drawing
commands are located in the left bar, where as file management and
other general commands are located in the top menu bar.
.PP
In the left bar, some commands are represented by icons. They are,
from left to right and up to down, \fIFlip horizontally\fP, \fIUp\fP,
\fIFlip vertically\fP, \fILeft\fP, \fIFold\fP, \fIRight\fP, \fIRotate
right\fP (counterclock), \fIDown\fP, \fIRotate left\fP (clockwise).
.PP
Some commands are also available directly through the keyboard when
the mouse cursor is located on the Pixmap widget. They will be
mentionned as an accelerator in the following description. 
.PP
LEFT BAR COMMANDS
.RS .5in
.TP 4
.I Undo
This command is used to undo the last operation. Only one operation
can be undone.
The accelerator of this command is Any<Key>u.
.TP 4
.I Clear
This command is used to clear all of the pixels in the pixmap as if Button 3 
had been dragged through every pixel in the pixmap. 
The accelerator of this command is [Shift]<Key>c.
.TP 4
.I Set
This command is used to set all of the pixels in the pixmap to the
current color, as if Button 1 had been dragged through every pixel in
the pixmap. 
The accelerator of this command is [Shift]<Key>s.
.TP 4
.I Redraw
This command is used to redisplay the pixmap. 
The accelerator of this command is Ctrl<Key>l.
.TP 4
.I Copy
This command is used to copy a region of the pixmap from one location
to another. When this command is invoked, the region to copy should
 be specified by pressing Button 1, dragging the mouse and releasing
Button 1. The region can now be copied by pressing Button 1 with the
cursor located on the region selected, dragging the mouse and
releasing it where the upper left corner of the region should be
copied.  If a region was already selected with a Mark command, only
the second phase of the copy is necessary.  The accelerator of this
command is available when a region has already been selected and is
Ctrl<Btn2Down> to drag the region and Ctrl<Btn2Up> to draw it to
point. This accelerated command is identical to the Paste command
available through the \fIEdit\fP menu of the top menu bar.  
.TP 4 
.I Move 
This command is used to move a region of the pixmap from one
location to another. When this command is invoked, the region to move
should be specified by pressing Button 1, dragging the mouse and
releasing Button 1. The region can now be moved by pressing Button 1
with the cursor located on the region selected, dragging the mouse and
releasing it where the upper left corner of the region should be
moved. The initial region is cleared.  If a region was already
selected with a Mark command, only the second phase of the move is
necessary.  
.TP 4 
.I Mark 
This command is used to mark a region to move or copy it later
(commands \fIMove\fP and \fICopy\fP above), or to put it in the
Cut&Paste buffer (commands \fICut\fP and \fICopy\fP of the \fIEdit\fP
menu of the top menu bar). When this command is invoked, the region
should be specified by pressing Button 1, dragging the mouse and
releasing Button 1. Once marked, the region is highlighted.  The
accelerator of this command is Ctrl<Btn1Down> to initiate the
selection and Ctrl<Btn1Up> to finish it.
.TP 4 
.I Unmark
This command is used to unmark a region previously marked. It will
unhighlight the region.  The accelerator of this command is
Ctrl<Btn3Down>.  
.TP 4 
.I Flip horizontally 
This command is used to flip horizontally the whole pixmap or the
marked region. This means mirroring horizontally the pixmap image. The
mirror is placed at the middle of the pixmap height.  The accelerator
of this command is [Shift|Ctrl]<Key>h.
.TP 4 
.I Up 
This command is used to move the whole pixmap or the marked region up.
Pixels at the top of the pixmap are pushed back at the bottom of the
new pixmap.  The accelerator of this command is Any<Key>Up (not
available in Motif version).
.TP 4 
.I Flip vertically 
This command is used to flip vertically the whole pixmap or the marked
region. This means mirroring vertically the pixmap image. The mirror
is placed at the middle of the pixmap width.  The accelerator of this
command is Any<Key>v.
.TP 4 
.I Left 
This command is used to move the whole pixmap or the marked region left.
Pixels at the left of the pixmap are pushed back at the right of the
new pixmap.  The accelerator of this command is Any<Key>Left (not
available in Motif version).  
.TP 4 
.I Fold 
This command is used to "Fold" the pixmap. This means splitting the
pixmap image in four squares (top left, top right, bottom left and
bottom right) and inverting them (top becomes bottom, left becomes
right, and so on).  "Folding" twice a pixmap does no change.  The
accelerator of this command is [Shift|Ctrl]<Key>f.
.TP 4 
.I Right 
This command is used to move the whole pixmap or the marked region
right. Pixels at the right of the pixmap are pushed back at the left
of the new pixmap.  The accelerator of this command is Any<Key>Right
(not available in Motif version).
.TP 4 
.I Rotate right 
This command is used to rotate the pixmap image or the marked region
right (clockwise) of 90 degrees.  Four \fIRotate right\fP operations
does no change.  The accelerator of this command is
[Shift|Ctrl]<Key>r.
.TP 4 
.I Down 
This command is used to move the whole pixmap or the marked region
down. Pixels at the bottom of the pixmap are pushed back at the top of
the new pixmap.  The accelerator of this command is Any<Key>Down (not
available in Motif version).
.TP 4 
.I Rotate left 
This command is used to rotate the pixmap image or the marked region
left (counterclock) of 90 degrees. Four \fIRotate left\fP operations
does no change.  The accelerator of this command is [Shift]<Key>l.
.TP 4 
.I Point 
This command is used to set, invert or clear a pixel to the current color.
It can be considered as a mode. After selecting it, pixels are set,
inverted or cleared depending on the button used (see Pixels Editing
with the Mouse). If the mouse button remains pressed while dragging
the mouse, more than one pixel can be affected.  This command has no
accelerator.  
.TP 4 
.I Curve 
This command is used to draw curved lines (set, cleared or inverted).
The curve is drawn while dragging the mouse. This command can be
considered as a mode. Quite the same affect can be obtained by
dragging the mouse in point mode, the main difference resides in the
fact that pixels will be drawn contiguously.  This command has no
accelerator.
.TP 4 
.I Line
This command is used to draw lines between two points (set, cleared or
inverted). The lines are first drawn highlighted while mouse button
remains pressed. This command can be considered as a mode.  This
command has no accelerator.
.TP 4 
.I Rectangle 
This command is used to draw rectangles between two points defining
the two opposite corners of the rectangle (set, cleared or inverted).
The rectangles are first drawn highlighted while mouse button remains
pressed. This command can be considered as a mode.  This command has
no accelerator.
.TP 4 
.I Filled Rectangle
This command is used to draw filled rectangles between two points
defining the two opposite corners of the rectangle (set, cleared or
inverted).  The rectangles outlines are first drawn highlighted while
mouse button remains pressed. This command can be considered as a
mode.  This command has no accelerator.  
.TP 4 
.I Circle 
This command will set, invert or clear the pixels on a circle
specified by a center and a point on the curve. Small circles may not
look very round because of the size of the pixmap and the limits of
having to work with discrete pixels. This command can be considered as
a mode.  This command has no accelerator.
.TP 4 
.I Filled Circle 
This command will set, invert or clear all of the pixels in a circle
specified by a center and a point on the curve. All pixels side and
including the circle are set. This command can be considered as a
mode.  This command has no accelerator.
.TP 4 
.I Flood Fill 
This command will set all clear pixels in an enclosed shape. The
enclosed shape is determined by all the pixels whose color is
different from the color of the pixel on which the user has clicked.
If the shape is not closed, the entire pixmap will be filled. This
command can be considered as a mode.  This command has no accelerator.
.TP 4 
.I Set Hot Spot 
This command allows the specification of a Hot Spot. The Hot
Spot is selected by clicking the \fISet\fP mouse button. Clicking
\fIInvert\fP will invert the Hot Spot, set or reset it depending on
its previous state. Hot spot is useful for cursor pixmaps and are used
to reference the sensible part of the pixmap.  This command has no
accelerator.  
.TP 4 
.I Clear Hot Spot 
This command clears the current Hot Spot.  This command has no accelerator.  
.TP 4 
.I Set Port 
This command allows to create a Port extension line graphically. It is
part of the customized Port extension editor developped by Tim Wise
(SES Inc.). The Port is set on the pixmap image by clicking any of the
mouse button.  This command has no acelerator.
.TP 4 
.I Clear Port
This command allows to remove a Port extension line graphically. It is
part of the customized Port extension editor developped by Tim Wise
(SES Inc.). The Port onto which any mouse button was clicked is
cancelled.  This command has no accelerator.  
.TP 4 
.I Move Port 
This command allows to move a Port, that is to change the coordinates
specified in the Port extension line. It is part of the customized
Port extension editor developped by Tim Wise (SES Inc.). The Port onto
which any mouse button was pressed is moved with the mouse cursor
until the mouse button is released.  This command has no accelerator.
.TP 4 
.I Port Info... 
This command allows to edit the information associated to a Port, that
is contained in a Port extension line. It is part of the customized
Port extension editor developped by Tim Wise (SES Inc.).  The
information associated with the Port onto which any mouse button was
clicked is displayed in a dialog window. It can be edited in that
dialog and saved by clicking the "Okay" button of the dialog.  This
command has no accelerator.  
.PP 
.RE 
TOP MENU COMMANDS
.RS .5in 
.TP 4 
.I Info 
This command pops up an info window.  
.PP 
.RE 
\fIFile\fP MENU 
.RS .5in 
.TP 4 
.I Load...  
This command is used to load a pixmap file in the pixmap editor. A
dialog window is poped up in which a filename has to be provided. The
operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Alt<Key>l.
.TP 4 
.I Insert...  
This command is used to load a pixmap in the Cut&Paste buffer of the
pixmap editor. The contents of the pixmap file can then be pasted on
the current pixmap. A dialog window is poped up in which a filename
has to be provided. The operation can be interrupted with the
\fICancel\fP button of the dialog window.  The accelerator of this
command is Alt<Key>i.
.TP 4 
.I Save 
This command is used to save the current pixmap in the current file
edited. By default, and until otherwise changed by a
\fIFilename...\fP, \fILoad...\fP or \fISave As...\fP operation, or by
specifying the filename on the command line, the filename is
\fIscratch\fP. The \fIFilename...\fP command can be used to change
this default filename.  The accelerator of this command is Alt<Key>s.
.TP 4 
.I Save As...  
This command is used to save the current pixmap in a particular file
which name has to be provided in the dialog window which pops up. The
operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Alt<Key>a.
.TP 4 
.I Resize...  
This command is used to resize the current pixmap to the width and
height specified in the dialog window which pops up. The syntax is
WIDTHxHEIGHT. This operation is different from the \fIRescale...\fP
one in the way that it just add or remove pixels to the current pixmap
without trying to fit the space correctly with the pixmap image. The
operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Alt<Key>r.
.TP 4 
.I Rescale...  
This command is used to rescale the current pixmap image in order to
make it fit a larger or smaller space. The new width and height have
to be specified in the dialog window which pops up with the syntax
WIDTHxHEIGHT. The operation can be interrupted with the \fICancel\fP
button of the dialog window.  The accelerator of this command is
Alt<Key>e.
.TP 4 
.I Filename...  
This command is used to change the current filename, i.e., the name of
the file in which the pixmap will be saved with a \fISave\fP
operation.  The new filename has to be provided in the dialog window
which pops up. The operation can be interrupted with the \fICancel\fP
button of the dialog window.  The accelerator of this command is
Alt<Key>f.
.TP 4 
.I Hints comment...
This command pops up a dialog window in which the user can specify the
hints section comment of the pixmap file. The operation can be
interrupted with the \fICancel\fP button of the dialog window.  The
accelerator of this command is Alt<Key>h.
.TP 4 
.I Colors comment...
This command pops up a dialog window in which the user can specify the
colors section comment of the pixmap file. The operation can be
interrupted with the \fICancel\fP button of the dialog window.  The
accelerator of this command is Alt<Key>c.
.TP 4 
.I Pixels comment...
This command pops up a dialog window in which the user can specify the
pixels section comment of the pixmap file. The operation can be
interrupted with the \fICancel\fP button of the dialog window.  The
accelerator of this command is Alt<Key>p.
.TP 4 
.I Quit 
This command causes \fIpixmap\fP to display a dialog box asking
whether or not it should save the pixmap (if it has changed) and then
exit.  Answering \fIyes\fP is the same as invoking \fISave\fP;
\fIno\fP causes \fIpixmap\fP to simply exit; and \fIcancel\fP will
abort the \fIQuit\fP command so that more changes may be made.  The
accelerator of this command is Alt<Key>q.  
.PP 
.RE 
\fIEdit\fP MENU 
.RS .5in
.TP 4
.I Image 
This command pops up a window in which the real size pixmap
is shown.  This window can be closed by clicking the mouse in it or by
invoking \fIImage\fP once again. When the window is poped up, an
\fIX\fP mark is displayed in the menu at the left of the \fIImage\fP
label.  The accelerator of this command is <Key>i.  
.TP 4 
.I Grid 
This command toggles the display of the grid. When the grid is displayed,
an \fIX\fP mark is added at the left of the \fIGrid\fP label.  The
accelerator of this command is <Key>g.  
.TP 4 
.I Axes 
This command toggles the display of axes. When axes are displayed, an
\fIX\fP mark is added at the left of the \fIAxes\fP label.  The
accelerator of this command is <Key>a.
.TP 4 
.I Proportional 
This command toggles the display in proportional mode of the pixmap.
Proportional mode means that the Pixmap widget won't try to fit all
the available space within the interface and will rather display each
pixel in a square, probably leaving some space around the pixmap
widget. When the proportional mode is active, an \fIX\fP mark is added
at the left of the \fIProportional\fP label.  The accelerator of this
command is <Key>p.
.TP 4 
.I Zoom 
This command is used to zoom some pixels of the current
pixmap. The zooming region has to be selected by the use as a
rectangle region just as if he was marking a region (see \fIMark\fP
command). The operation can be interrupted by invoking any other
command. When a region is zoomed, an \fIX\fP mark is added at the left
of the \fIZoom\fP label. Invoking once again the \fIZoom\fP command
zooms out.  The accelerator of this command is <Key>z.  
.TP 4 
.I Zoom In 
This command is used to incrementaly zoom into the current pixmap.
This side effect of this is to enlarge the size of a square used to
represent a single pixel.  The accelerator of this command is <Key>x.
.TP 4 
.I Zoom Out 
This command is used to incrementaly zoom out of the current pixmap.
This side effect of this is to reduce the size of a square used to
represent a single pixel.  The accelerator of this command is <Key>y.
.TP 4 
.I Zooming Factor 
The command pops up a dialog window in which the user can edit the
current zooming factor.  The zooming factor is the size of a square
used to represent a single pixel.  Enlarging the zooming factor will
zoom into the current pixmap, while reducing it will zoom out of the
pixmap.  The accelerator of this command is <Key>f.
.TP 4 
.I Cut 
When a region is marked, this operation is active. It is used to cut
the contents of the region to put it in the Cut&Paste buffer. The
\fIPaste\fP command now becomes active and the marked region is
unmarked. The pixels in the marked region are cleared. This command
acts as the \fIMove\fP one when a region is already marked.  The
accelerator of this command is Ctrl<Key>c.
.TP 4 
.I Copy 
When a region is marked, this operation is active. It is used to copy
the contents of the region in the Cut&Paste buffer. The \fIPaste\fP
command now becomes active and the marked region is unmarked. This
command acts as the \fICopy\fP command of the left border when a
region is already marked.  The accelerator of this command is
Ctrl<Key>x.
.TP 4 
.I Paste 
When a region has been cut or copied in the Cut&Paste buffer, this
command is active and can be used to paste the contents of the
Cut&Paste buffer where the mouse button is clicked. The paste
operation takes care of the button used to specify the point where to
paste the buffer. The button can remain pressed to move the buffer
around and then be released to paste the buffer at the current
location.  A \fICopy\fP and \fIPaste\fP operation can be accelerated
by Ctrl<Btn2Down> to intiate the operation and Ctrl<Btn2Up> to finish
the operation, i.e., paste the buffer.  The accelerator of this
command is Ctrl<Key>p.
.TP 4 
.I Crop
When a region is marked, or a file has been inserted in the Cut&Paste
buffer, this command will exchange the current pixmap with the marked
region, or the Cut&Paste buffer. Cropping twice does nothing.
The accelerator of this command is Ctrl<Key>o.
.PP 
.RE 
\fIForeground Color\fP MENU 
.RS .5in 
.TP 4 
.I Add color...  
This command is used to add a new color in the \fIColor Panel\fP (see
below). The color name is specified in the dialog window which pops up
either by a real color name found in rgb\.txt file or by a string like
\fI#rrggbb\fP where \fIrr\fP, \fIgg\fP and \fIbb\fP represent the red,
green and blue components of the color in hexadecimal format. The
operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Ctrl<Key>a.
.TP 4 
.I Symbolic name...
This command is used to set the symbolic name of the current color.
The symbolic name is entered in the dialog window which pops up. The
operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Ctrl<Key>s.  
.TP 4
.I Monochrome name...  
This command is used to set the monochrome name of the current color,
i.e., the name of the color to use on monochrome displays. The
monochrome name is entered in the dialog window which pops up. The
operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Ctrl<Key>m.
.TP 4 
.I Grey scale 4 name...  
This command is used to set the grey scale 4 name of the current
color, i.e., the name of the color to use on grey scale 4 displays.
The grey scale 4 name is entered in the dialog window which pops up.
The operation can be interrupted with the \fICancel\fP button of the
dialog window.  The accelerator of this command is Ctrl<Key>4.
.TP 4 
.I Grey scale name...  
This command is used to set the grey scale name of the current color,
i.e., the name of the color to use on grey scale (with more then 4
levels) displays.  The grey scale name is entered in the dialog window
which pops up. The operation can be interrupted with the \fICancel\fP
button of the dialog window.  The accelerator of this command is
Ctrl<Key>g.
.TP 4
.I Color name...  
This command is used to set the color name of the current color. This
change will be considered when saving the pixmap but to remain
visible, it affects the label of the menu item of the color. This is
useful to directly change a specific color for another one or to allow
multiple symbols to represent the same color (the color can be the
same on color display but change on grey scale or monochrome ones).
The color name is entered in the dialog window which pops up. The
operation can be interrupted with the \fICancel\fP button of the
dialog window. The \fINone\fP (not case sensitive) name is used to
change the pixel representing the transparent color.  The accelerator
of this command is Ctrl<Key>n. 
.PP 
.RE 
\fIXpm Extensions\fP MENU 
.RS .5in 
.TP 4 
.I Add Extension...  
This command pops up a dialog window into which the user provides a
name for an extension to be added in the current pixmap extensions
list. The operation can be interrupted with the \fICancel\fP button of
the dialog window. If the user confirms with the \fIOkay\fP button,
another dialog windows pops up where the user can edit the extension
contents. When the user clicks on the \fICancel\fP button into this
extension editing window, the edit operation is interrupted but the
extension is added to the extensions list of the current pixmap. If
the user wishes to abort the \fIAdd Extension...\fP operation, he/she
needs to click on the \fIRemove\fP button. The edition can otherwise
be confirmed by clicking on the \fIOkay\fP button.
.TP 4
.I Any extension name
WHen an extension is added in the extensions list of the current
pixmap, its name appears in the \fIXpm Extensions\fP menu. When
selected in the menu, the extension edition window pops up. See above
for its description.
.RE 

In addition the Motif version defines the status label
as two active buttons which operate as \fIFilename...\fP and
\fIResize...\fP commands.
.SH "COLOR PANEL"
Colors in pixmap are presented in the \fIColor Panel\fP. Each loaded
color is associated a square button, filled with the color pixel.
Scrollbars around the panel allow to scan the whole panel. To choose a
color for drawing, the user must click on a color button. At this
time, the current name of the color is displayed as the title of the
\fIForeground Color\fP menu. A color can also be selected by using 
Shift<BtnDown> on a pixel of the current pixmap which color should be
used. This accelerator is very useful when modifying small parts of a
pixmap locally. 
.SH "FILE FORMAT"
The \fISave\fP or \fISave As...\fP commands store pixmaps using the
format defined by Arnaud Le Hors in his Xpm library (version 3.x).
Each pixmap is a C string array variable that can be included and used
within programs, or referred to by X Toolkit pixmap resources
(assuming that a String to Pixmap converter has been registered on the
server). Here is an example of a pixmap file:
.bp
.nf
/* XPM */
static char * plaid[] = {

/* plaid pixmap 
 * width height ncolors chars_per_pixel */

 "22 22 4 2 ",

/* colors */

 "   c red         m white  s light_color ",
 "Y  c yellow      m black  s lines_in_mix ",
 "+  c yellow      m white  s lines_in_dark ",
 "x                m black  s dark_color ",

/* pixels */

 "x   x   x x x   x   x x x x x x + x x x x x ", 
 "  x   x   x   x   x   x x x x x x x x x x x ", 
 "x   x   x x x   x   x x x x x x + x x x x x ", 
 "  x   x   x   x   x   x x x x x x x x x x x ", 
 "x   x   x x x   x   x x x x x x + x x x x x ", 
 "Y Y Y Y Y x Y Y Y Y Y + x + x + x + x + x + ", 
 "x   x   x x x   x   x x x x x x + x x x x x ", 
 "  x   x   x   x   x   x x x x x x x x x x x ", 
 "x   x   x x x   x   x x x x x x + x x x x x ", 
 "  x   x   x   x   x   x x x x x x x x x x x ", 
 "x   x   x x x   x   x x x x x x + x x x x x ", 
 "          x           x   x   x Y x   x   x ", 
 "          x             x   x   Y   x   x   ",
 "          x           x   x   x Y x   x   x ", 
 "          x             x   x   Y   x   x   ", 
 "          x           x   x   x Y x   x   x ", 
 "x x x x x x x x x x x x x x x x x x x x x x ", 
 "          x           x   x   x Y x   x   x ", 
 "          x             x   x   Y   x   x   ", 
 "          x           x   x   x Y x   x   x ", 
 "          x             x   x   Y   x   x   ", 
 "          x           x   x   x Y x   x   x "
};

.fi
.sp
The \fBplaid\fP name used to reference the pixmap variable is
constructed from the name of the file in which is saved the pixmap.
Any directories are stripped off the front of the name 
and any suffix beginning with a period is stripped off the end.  
.PP
The pixmap variable is a string array in which the first string of the
array contains the width, height, number of colors and number of
characters per pixel.
.PP
The following strings represent the color descriptions, one string per
color. A color description can be composed of one or more characters
that represent a pixel, and color display name preceded by the `c'
character, and/or a symbolic name preceded by the `s' character,
and/or a monochrome display name preceded by the `m' character, and or
a grey scale 4 levels display name preceded by the string `g4' ,
and/or a grey scale display name preceded by the aharacter `g',
specified in any order.
.PP
Following color description strings, each string represent a line of
the pixmap, composed of symbolic characters assigned to colors.
.PP
.SH USING PIXMAPS IN PROGRAMS
The format of pixmap files is designed to make pixmaps easy to
use within X programs, whatever your display is.  The following code
could be used to create a pixmap to use as a window background, using
the enhanced Xpm library (version 3.3) from Groupe Bull and assuming
that the pixmap was stored in a file name \fIplaid.xpm\fP:
.sp
.nf
        #include "plaid.xpm"

        Pixmap pixmap;
    
        XpmCreatePixmapFromData(display, drawable, plaid,
           &pixmap, &pixmap_mask, &attributes);
.fi
.PP
Additional routines are available for reading in \fIpixmap\fP files and 
returning the data in the file in Pixmaps.
.PP
Lines where only appears one or the other type of a widget (like
Dialog| or |CascadeButtonGadget) mean that the widget doesn't exist
in one or the other version. In the case of dialogs in the Motif
version, the widgets are created by means of convenient routines which
assign the name of the widget depending on the name of the dialog. By
the way, we can't provide with a list of types and names for the
substructure of dialog widgets in the Motif version. However, these
shouldn't be often modified.
.SH X DEFAULTS
.PP
In addition to the standard Athena or Motif widgets resources, \fIpixmap\fP
uses the following resources for the Pixmap widget (named pixmap):
.TP 4
.B Cursor
The cursor to use within the Pixmap widget.
.PP
.TP 4
.B Foreground
The initial foreground color for drawing.
.TP 4
.B Highlight
The highlighting color.
.TP 4
.B Framing
The framing color, used to draw grid and axes.
.TP 4
.B Transparent
The color representing transparent pixels.
.TP 4
.B Proportional
Toggles initial proportional display mode.
.TP 4
.B Grid
Toggles initial grid display.
.TP 4
.B GridTolerance
Determines when to display grid according to SquareSize.
.TP 4
.B Stippled
Suppress stipple drawing of transparent pixels.
.TP 4
.B Stipple
Depth 1 pixmap to use to draw transparent pixels stippled.
.TP 4
.B Axes
Toggles axes display.
.TP 4
.B Resize
Toggles Pixmap widget resize when requesting by window manager.
.TP 4
.B Distance
The margin around Pixmap widget.
.TP 4
.B SquareSize
The size in screen points used to display each pixmap pixels. 
.TP 4
.B PixmapWidth
The initial width of the pixmap.
.TP 4
.B PixmapHeight
The initial height of the pixmap.
.TP 4
.B Button1Action
The action associated to mouse button 1 (between Set, Invert and Clear).
.TP 4
.B Button2Action
The action associated to mouse button 2 (between Set, Invert and Clear).
.TP 4
.B Button3Action
The action associated to mouse button 3 (between Set, Invert and Clear).
.TP 4
.B Button4Action
The action associated to mouse button 4 (between Set, Invert and Clear).
.TP 4
.B Button5Action
The action associated to mouse button 5 (between Set, Invert and
Clear).
.TP 4
.B Filename
The initial file to load.
.TP 4
.B AddColorNtfyProc
The procedure to call when reading a pixmap file to notify color
loading. It is strongly advised not to change this resource.
.TP 4
.B ExtensionNtfyProc
The procedure to call when reading a pixmap file to notify extension
loading. It is strongly advised not to change this resource.
.SH "SEE ALSO"
X(1), \fIXpm library manual\fP,  \fIXlib - C Language X Interface\fP
(particularly the section on \fIManipulating Pixmaps\fP)
.SH BUGS
.PP
If you move the pointer too fast while holding a pointer button down,
some pixels may be missed.  This is caused by limitations in how
frequently the X server can sample the pointer location.
.PP
Loading a pixmap file where the same color is used more than once with
different symbols and descriptions, and writing it will loose
information concerning the color used more than once. The pixmap file
plaid given as an example in this man won't be saved that way by
\fIpixmap\fP.
.PP
Accelerators to menu operations don't seem to work with Athena
version.
.PP
In the Motif version, the \fIFilename...\fP and \fIResize...\fP
commands open their respective dialog window in a strange mode. The user
has to voluntary (;-) give the focus to the text widget inside to be able
to change its content.
.SH COPYRIGHT
Copyright 1991,1992,1993,1994 - Lionel Mallet.
.SH AUTHOR
\fIpixmap\fP by Lionel Mallet - Simulog. 
Extension edition and customized Port editor by Tim Wise - SES Inc.

